<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Autopilot\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Rest\Autopilot\V1\Assistant\DefaultsList;
use Twilio\Rest\Autopilot\V1\Assistant\DialogueList;
use Twilio\Rest\Autopilot\V1\Assistant\ExportAssistantList;
use Twilio\Rest\Autopilot\V1\Assistant\FieldTypeList;
use Twilio\Rest\Autopilot\V1\Assistant\ModelBuildList;
use Twilio\Rest\Autopilot\V1\Assistant\QueryList;
use Twilio\Rest\Autopilot\V1\Assistant\StyleSheetList;
use Twilio\Rest\Autopilot\V1\Assistant\TaskList;
use Twilio\Rest\Autopilot\V1\Assistant\WebhookList;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 *
 * @property FieldTypeList $fieldTypes
 * @property TaskList $tasks
 * @property ModelBuildList $modelBuilds
 * @property QueryList $queries
 * @property StyleSheetList $styleSheet
 * @property DefaultsList $defaults
 * @property DialogueList $dialogues
 * @property WebhookList $webhooks
 * @property ExportAssistantList $exportAssistant
 * @method \Twilio\Rest\Autopilot\V1\Assistant\FieldTypeContext fieldTypes(string $sid)
 * @method \Twilio\Rest\Autopilot\V1\Assistant\TaskContext tasks(string $sid)
 * @method \Twilio\Rest\Autopilot\V1\Assistant\ModelBuildContext modelBuilds(string $sid)
 * @method \Twilio\Rest\Autopilot\V1\Assistant\QueryContext queries(string $sid)
 * @method \Twilio\Rest\Autopilot\V1\Assistant\StyleSheetContext styleSheet()
 * @method \Twilio\Rest\Autopilot\V1\Assistant\DefaultsContext defaults()
 * @method \Twilio\Rest\Autopilot\V1\Assistant\DialogueContext dialogues(string $sid)
 * @method \Twilio\Rest\Autopilot\V1\Assistant\WebhookContext webhooks(string $sid)
 * @method \Twilio\Rest\Autopilot\V1\Assistant\ExportAssistantContext exportAssistant()
 */
class AssistantContext extends InstanceContext {
    protected $_fieldTypes;
    protected $_tasks;
    protected $_modelBuilds;
    protected $_queries;
    protected $_styleSheet;
    protected $_defaults;
    protected $_dialogues;
    protected $_webhooks;
    protected $_exportAssistant;

    /**
     * Initialize the AssistantContext
     *
     * @param Version $version Version that contains the resource
     * @param string $sid The unique string that identifies the resource
     */
    public function __construct(Version $version, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['sid' => $sid, ];

        $this->uri = '/Assistants/' . \rawurlencode($sid) . '';
    }

    /**
     * Fetch a AssistantInstance
     *
     * @return AssistantInstance Fetched AssistantInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): AssistantInstance {
        $params = Values::of([]);

        $payload = $this->version->fetch(
            'GET',
            $this->uri,
            $params
        );

        return new AssistantInstance($this->version, $payload, $this->solution['sid']);
    }

    /**
     * Update the AssistantInstance
     *
     * @param array|Options $options Optional Arguments
     * @return AssistantInstance Updated AssistantInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): AssistantInstance {
        $options = new Values($options);

        $data = Values::of([
            'FriendlyName' => $options['friendlyName'],
            'LogQueries' => Serialize::booleanToString($options['logQueries']),
            'UniqueName' => $options['uniqueName'],
            'CallbackUrl' => $options['callbackUrl'],
            'CallbackEvents' => $options['callbackEvents'],
            'StyleSheet' => Serialize::jsonObject($options['styleSheet']),
            'Defaults' => Serialize::jsonObject($options['defaults']),
            'DevelopmentStage' => $options['developmentStage'],
        ]);

        $payload = $this->version->update(
            'POST',
            $this->uri,
            [],
            $data
        );

        return new AssistantInstance($this->version, $payload, $this->solution['sid']);
    }

    /**
     * Deletes the AssistantInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->version->delete('delete', $this->uri);
    }

    /**
     * Access the fieldTypes
     */
    protected function getFieldTypes(): FieldTypeList {
        if (!$this->_fieldTypes) {
            $this->_fieldTypes = new FieldTypeList($this->version, $this->solution['sid']);
        }

        return $this->_fieldTypes;
    }

    /**
     * Access the tasks
     */
    protected function getTasks(): TaskList {
        if (!$this->_tasks) {
            $this->_tasks = new TaskList($this->version, $this->solution['sid']);
        }

        return $this->_tasks;
    }

    /**
     * Access the modelBuilds
     */
    protected function getModelBuilds(): ModelBuildList {
        if (!$this->_modelBuilds) {
            $this->_modelBuilds = new ModelBuildList($this->version, $this->solution['sid']);
        }

        return $this->_modelBuilds;
    }

    /**
     * Access the queries
     */
    protected function getQueries(): QueryList {
        if (!$this->_queries) {
            $this->_queries = new QueryList($this->version, $this->solution['sid']);
        }

        return $this->_queries;
    }

    /**
     * Access the styleSheet
     */
    protected function getStyleSheet(): StyleSheetList {
        if (!$this->_styleSheet) {
            $this->_styleSheet = new StyleSheetList($this->version, $this->solution['sid']);
        }

        return $this->_styleSheet;
    }

    /**
     * Access the defaults
     */
    protected function getDefaults(): DefaultsList {
        if (!$this->_defaults) {
            $this->_defaults = new DefaultsList($this->version, $this->solution['sid']);
        }

        return $this->_defaults;
    }

    /**
     * Access the dialogues
     */
    protected function getDialogues(): DialogueList {
        if (!$this->_dialogues) {
            $this->_dialogues = new DialogueList($this->version, $this->solution['sid']);
        }

        return $this->_dialogues;
    }

    /**
     * Access the webhooks
     */
    protected function getWebhooks(): WebhookList {
        if (!$this->_webhooks) {
            $this->_webhooks = new WebhookList($this->version, $this->solution['sid']);
        }

        return $this->_webhooks;
    }

    /**
     * Access the exportAssistant
     */
    protected function getExportAssistant(): ExportAssistantList {
        if (!$this->_exportAssistant) {
            $this->_exportAssistant = new ExportAssistantList($this->version, $this->solution['sid']);
        }

        return $this->_exportAssistant;
    }

    /**
     * Magic getter to lazy load subresources
     *
     * @param string $name Subresource to return
     * @return ListResource The requested subresource
     * @throws TwilioException For unknown subresources
     */
    public function __get(string $name): ListResource {
        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown subresource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments): InstanceContext {
        $property = $this->$name;
        if (\method_exists($property, 'getContext')) {
            return \call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Autopilot.V1.AssistantContext ' . \implode(' ', $context) . ']';
    }
}