<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Authy\V1\Service\Entity;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class FactorOptions {
    /**
     * @param string $authPayload Optional payload to verify the Factor for the
     *                            first time
     * @param string $friendlyName The friendly name of this Factor
     * @param string $config The config for this Factor as a json string
     * @return UpdateFactorOptions Options builder
     */
    public static function update(string $authPayload = Values::NONE, string $friendlyName = Values::NONE, string $config = Values::NONE): UpdateFactorOptions {
        return new UpdateFactorOptions($authPayload, $friendlyName, $config);
    }
}

class UpdateFactorOptions extends Options {
    /**
     * @param string $authPayload Optional payload to verify the Factor for the
     *                            first time
     * @param string $friendlyName The friendly name of this Factor
     * @param string $config The config for this Factor as a json string
     */
    public function __construct(string $authPayload = Values::NONE, string $friendlyName = Values::NONE, string $config = Values::NONE) {
        $this->options['authPayload'] = $authPayload;
        $this->options['friendlyName'] = $friendlyName;
        $this->options['config'] = $config;
    }

    /**
     * The optional payload needed to verify the Factor for the first time. E.g. for a TOTP, the numeric code.
     *
     * @param string $authPayload Optional payload to verify the Factor for the
     *                            first time
     * @return $this Fluent Builder
     */
    public function setAuthPayload(string $authPayload): self {
        $this->options['authPayload'] = $authPayload;
        return $this;
    }

    /**
     * The new friendly name of this Factor
     *
     * @param string $friendlyName The friendly name of this Factor
     * @return $this Fluent Builder
     */
    public function setFriendlyName(string $friendlyName): self {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The new config for this Factor. It must be a json string with the required properties for the given factor type
     *
     * @param string $config The config for this Factor as a json string
     * @return $this Fluent Builder
     */
    public function setConfig(string $config): self {
        $this->options['config'] = $config;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = [];
        foreach ($this->options as $key => $value) {
            if ($value !== Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Authy.V1.UpdateFactorOptions ' . \implode(' ', $options) . ']';
    }
}