@extends('userlayout')

@section('content')
<div class="content-w">
    <div class="content-i">
        <div class="content-box">
            <div class="element-wrapper">
                <div class="element-box-tp">
                    <h5 class="form-header">Withdrawal</h5>
                    <h3 class="">You can send cash out request for balance.</h3>
                    <p class="mt-0 mb-5">Service charge is {{$set->withdraw_charge}}%.</p>
                    <a data-toggle="modal" data-target="#modal-formx" href="" class="btn btn-primary"><i class="fa fa-arrow-right"></i> Create request</a>

                </div>
                    <div class="content-box">
                      <div class="element-wrapper">
                            <h6 class="element-header">Deposit Logs</h6>
                            <div class="element-box-tp">
                                <div class="table-responsive">
                                    <table class="table table-padded">
                                        <thead>
                                            <tr>
                                                <th>S/N</th>
                                                <th>Reference ID</th>
                                                <th>Amount</th>
                                                <th>Method</th>
                                                <th>Status</th>
                                                <th>Charge</th>
                                                <th>Created</th>
                                                <th>Last updated</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($withdraw as $k => $val)
                                            <tr>
                                                <td>{{++$k}}.</td>
                                                <td>#{{$val->reference}}</td>
                                                <td>{{$currency->symbol.number_format($val->amount)}}</td>
                                                <td>{{$val->wallet->method}}</td>
                                                <td>
                                                    @if($val->status==1)
                                                        <span class="badge badge-success">Approved</span>
                                                    @elseif($val->status==0)
                                                        <span class="badge badge-danger">Pending</span>
                                                    @elseif($val->status==2)
                                                        <span class="badge badge-info">Declined</span>
                                                    @endif
                                                </td>
                                                <td>{{$currency->symbol.number_format($val->amount*$set->withdraw_charge/100)}}</td>
                                                <td>{{date("Y/m/d h:i:A", strtotime($val->created_at))}}</td>
                                                <td>{{date("Y/m/d h:i:A", strtotime($val->updated_at))}}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="modal fade" id="modal-formx" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
                    <div class="modal-dialog modal- modal-dialog-centered modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-body p-0">
                                <div class="card bg-white border-0 mb-0">
                                    <div class="card-body px-lg-5 py-lg-5">
                                        <form action="{{route('withdraw.submit')}}" method="post">
                                            @csrf
                                            <div class="form-group row">
                                                <label class="col-form-label col-lg-2">Amount</label>
                                                <div class="col-lg-10">
                                                    <div class="input-group input-group-merge">
                                                        <div class="input-group-prepend">
                                                            <span class="input-group-text">{{$currency->symbol}}</span>
                                                        </div>
                                                        <input type="number" step="any" name="amount" maxlength="10" class="form-control" required="">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-lg-2">Method</label>
                                                <div class="col-lg-10">
                                                    <select class="form-control select" name="coin" data-dropdown-css-class="bg-primary" data-fouc required>
                                                        @foreach($method as $val)
                                                        <option value="{{$val->id}}">{{$val->method}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-lg-2">Details</label>
                                                <div class="col-lg-10">
                                                    <textarea name="details" class="form-control" rows="4" required></textarea>
                                                </div>
                                            </div>
                                            <div class="text-right">
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop
