@extends('userlayout')

@section('content')
<div class="content-w">
    <div class="content-i">
        <div class="content-box">
            <div class="element-wrapper">
                <div class="element-box-tp">
                    <h5 class="form-header">Make Deposit</h5>
                    @if($adminbank->status==1)
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <a href="{{route('user.bank_transfer')}}" class="avatar avatar-xl">
                                <img alt="Image placeholder" src="{{url('/')}}/asset/payment_gateways/webmoney.png">
                            </a>
                        </div>
                        <div class="col ml--2">
                            <h4 class="mb-0 text-primary">
                                <a href="{{route('user.bank_transfer')}}">Bank transfer</a>
                            </h4>
                            <p class="text-sm text-dark mb-0">Swift code: {{$adminbank->swift}}</p>
                            <p class="text-sm text-dark mb-0">Account number: {{$adminbank->acct_no}}</p>
                        </div>
                    </div>
                    @endif

                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Gateway</th>
                                <th>Limit</th>
                                <th>Charge</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($gateways as $val)
                            <tr>
                                <td>
                                    <a href="#" data-toggle="modal" data-target="#modal-form{{$val->id}}" class="avatar avatar-xl">
                                        <img alt="Image placeholder" src="{{url('/')}}/asset/payment_gateways/{{$val->gateimg}}" width="40">
                                    </a>
                                    <h4 class="mb-0 text-primary">
                                        <a href="#" data-toggle="modal" data-target="#modal-form{{$val->id}}">{{$val->name}}</a>
                                    </h4>
                                </td>
                                <td>{{$currency->symbol.number_format($val->minamo).' - '.$currency->symbol.number_format($val->maxamo)}}</td>
                                <td>{{$currency->symbol.$val->fixed_charge}} + {{$val->percent_charge}}%</td>
                                <td>
                                    <a class="btn btn-link btn-underlined" href="#" data-toggle="modal" data-target="#modal-form{{$val->id}}"><span>Make Deposit</span><i
                                        class="os-icon os-icon-arrow-right4"></i></a>
                                </td>
                            </tr>
                            <div class="modal fade" id="modal-form{{$val->id}}" tabindex="-1" role="dialog" aria-labelledby="modal-form" aria-hidden="true">
                            <div class="modal-dialog modal- modal-dialog-centered modal-sm" role="document">
                              <div class="modal-content">
                                <div class="modal-body p-0">
                                  <div class="card bg-white border-0 mb-0">
                                    <div class="card-header bg-transparent pb-5">
                                      <div class="text-muted text-center mt-2 mb-3"><small>Deposit via</small></div>
                                      <div class="btn-wrapper text-center">
                                        <a href="javascript:void;" class="btn btn-neutral btn-icon">
                                          <span class="btn-inner--icon"><img src="{{url('/')}}/asset/payment_gateways/{{$val->gateimg}}" width="100"></span>
                                        </a>
                                      </div>
                                    </div>
                                    <div class="card-body px-lg-5 py-lg-5">
                                      <form role="form" action="{{route('fund.submit')}}" method="post">
                                      @csrf
                                        <div class="form-group mb-3">
                                          <div class="input-group input-group-merge input-group-alternative">
                                            <div class="input-group-prepend">
                                              <span class="input-group-text">{{$currency->symbol}}</span>
                                            </div>
                                            <input type="number" step="any" class="form-control" placeholder="" name="amount" required>
                                            <input type="hidden" name="gateway" value="{{$val->id}}">  
                                          </div>
                                        </div>
                                        <div class="text-center">
                                          <button type="submit" class="btn btn-primary my-4">Preview</button>
                                        </div>
                                      </form>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div> 
                          
                          @endforeach
                        </tbody>
                    </table>

                    <div class="content-box">
                      <div class="element-wrapper">
                            <h6 class="element-header">Deposit Logs</h6>
                            <div class="element-box-tp">
                                <div class="table-responsive">
                                    <table class="table table-padded">
                                        <thead>
                                            <tr>
                                            <th>S/N</th>
                                            <th>Reference ID</th>
                                            <th>Amount</th>
                                            <th>Method</th>
                                            <th>Status</th>
                                            <th>Charge</th>
                                            <th>Created</th>
                                            <th>Last updated</th>

                                            </tr>
                                        </thead>
                                        <tbody>  
                                          @foreach($deposits as $k=>$val)
                                            <tr>
                                              <td>{{++$k}}.</td>
                                              <td>#{{$val->trx}}</td>
                                              <td>{{$currency->symbol.number_format($val->amount)}}</td>
                                              <td>{!!$val->gateway['name']!!}</td>
                                              <td>
                                              @if($val->status==1)
                                                <span class="badge badge-success">Approved</span>
                                              @elseif($val->status==0)
                                                <span class="badge badge-danger">Pending</span>                  
                                              @elseif($val->status==2)
                                                <span class="badge badge-info">Declined</span>
                                              @endif
                                              </td>
                                              <td>{{$currency->symbol.number_format($val->charge)}}</td>
                                              <td>{{date("Y/m/d h:i:A", strtotime($val->created_at))}}</td>
                                              <td>{{date("Y/m/d h:i:A", strtotime($val->updated_at))}}</td>
                                          </tr>
                                          @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                
                            </div>

                            <div class="content-box">
                      <div class="element-wrapper">
                            <h6 class="element-header">Bank Transfer Logs</h6>
                            <div class="element-box-tp">
                                <div class="table-responsive">
                                <table class="table table-flush" id="datatable-basic2">
                                <thead class="">
                                    <tr>
                                      <th>S/N</th>
                                      <th>Reference ID</th>
                                      <th>Amount</th>
                                      <th>Status</th>
                                      <th>Created</th>
                                      <th>Last updated</th>
                                    </tr>
                                  </thead>
                                  <tbody>  
                                  @foreach($bank_transfer as $k=>$val)
                                    <tr>
                                      <td>{{++$k}}.</td>
                                      <td>#{{$val->trx}}</td>
                                      <td>{{$currency->symbol.number_format($val->amount)}}</td>
                                      <td>
                                        @if($val->status==1)
                                          <span class="badge badge-success">Approved</span>
                                        @elseif($val->status==0)
                                          <span class="badge badge-danger">Pending</span>                  
                                        @elseif($val->status==2)
                                          <span class="badge badge-info">Declined</span>
                                        @endif
                                      </td>
                                      <td>{{date("Y/m/d h:i:A", strtotime($val->created_at))}}</td>
                                      <td>{{date("Y/m/d h:i:A", strtotime($val->updated_at))}}</td>
                                    </tr>
                                  @endforeach
                                </tbody>
                              </table>
                              </div>

                                
                            </div>                    
                
                
                
                
                
                </div>
            </div>
        </div>
    </div>
</div>
@stop
